# Avenir Tech Pvt Ltd - v2 Portal

**Manifesting the Future**  
We design and develop software that helps your business grow and thrive.

---

## What We Believe

At Avenir Tech, we believe technology should simplify life through innovation. That’s why we assist individuals and businesses in adopting user-friendly digital solutions that enhance productivity and support growth, providing tangible benefits at every stage.

---

## About This Project

This is the v2 portal app for Avenir Tech Pvt Ltd. It is designed to streamline our digital presence and showcase our services effectively. The app is built using modern web technologies to ensure a fast, scalable, and maintainable solution.

---

## Features

- Responsive, user-friendly UI
- Integration with backend APIs (if any)
- Custom components with reusable hooks
- Tailwind CSS for styling
- Fast deployment with Docker and GitLab CI/CD

---

## Services We Offer

1. Websites / Mobile Apps
2. Digital Marketing
3. Graphic Designing
4. Hosting & Maintenance

We leverage the latest technologies to ensure quicker delivery and solutions that exceed expectations.

---

## Tech Stack

- **Next.js** (React framework with server-side rendering)
- **TypeScript** for type safety
- **Tailwind CSS v4** for styling
- **Docker** for containerization
- **GitLab CI/CD** for automated deployment
- **Node.js** backend (if applicable)

---

## Getting Started

### Prerequisites

- Node.js (v18 or later recommended)
- npm or yarn
- Docker (for containerized deployment, optional)

### Installation & Running Locally

1. Clone the repository:

```
git clone https://github.com/avenirtech/v2portal.git
cd v2portal
```

2. Install dependencies:

```
npm install
```

3. Run the development server:

```
npm run dev
```

4. Open your browser and visit:

```
http://localhost:3000
```
