#!/bin/bash

set -e  # Exit on any command failure

IMAGE_NAME="v2portal"
TAG="latest"

echo "[INFO] Using image tag: $TAG"

# Step 1: Stop and remove existing containers
echo "[STEP] Stopping and removing existing containers..."
docker compose down

# Step 2: Remove the previous Docker image (if it exists)
echo "[STEP] Removing previous Docker image (if it exists)..."
docker rmi -f "${IMAGE_NAME}:${TAG}" || echo "[WARN] Image not found, skipping removal."

# Step 3: Build the Docker image
echo "[STEP] Building Docker image..."
docker build -t "${IMAGE_NAME}:${TAG}" .

# Step 4: Start the services with Docker Compose
echo "[STEP] Starting services with Docker Compose..."
docker compose up -d

# Step 5: Verify that the container is running
echo "[STEP] Verifying that the container is running..."
if ! docker ps | grep -q "${IMAGE_NAME}"; then
  echo "[ERROR] Container for ${IMAGE_NAME} is not running"
  exit 1
fi

# Step 6: Completion
echo "[SUCCESS] Deployment complete."
