"use client";
import Button from "@shared/components/Button";
import Navbar from "@shared/components/Navbar";
import Footer from "@shared/components/Footer";
import Image from "next/image";

const ContactUs = () => {
  const coordinates = "27.424722,85.026722";
  const googleMapsUrl = `https://www.google.com/maps?q=${coordinates}`;

  const handleMapClick = () => {
    window.open(googleMapsUrl, "_blank");
  };

  const handleWhatsAppClick = () => {
    const phoneNumber = "+9779865029558";
    const message = "Hello! I need support with HostingHo services.";
    const whatsappUrl = `https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappUrl, "_blank");
  };

  return (
    <>
      <Navbar />
      <div className="min-h-screen bg-white pt-0">
        {/* Map Section */}
        <section className="w-full h-[400px] md:h-[500px] relative">
          {/* View Larger Map Button */}
          <div className="absolute top-4 right-4 z-10">
            <Button
              variant="secondary"
              size="sm"
              onClick={handleMapClick}
              className="shadow-lg hover:shadow-xl transition-fast"
            >
              <svg
                className="w-4 h-4 mr-2"
                fill="none"
                stroke="currentColor"
                viewBox="0 0 24 24"
              >
                <path
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  strokeWidth={2}
                  d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"
                />
              </svg>
              View Larger Map
            </Button>
          </div>

          <div className="w-full h-full relative">
            <iframe
              src={`https://www.google.com/maps/embed/v1/place?key=AIzaSyBFw0Qbyq9zTFTd-tUY6dZWTgaQzuU17R8&q=${coordinates}&zoom=18`}
              width="100%"
              height="100%"
              style={{ border: 0 }}
              allowFullScreen
              loading="lazy"
              referrerPolicy="no-referrer-when-downgrade"
              title="HostingHo Location"
              className="w-full h-full"
            />
          </div>
        </section>
        {/* Contact Information Section */}
        <section className="px-[10px] md:px-[120px] py-16">
          <div className="mx-auto">
            {/* Header */}
            <div className="mb-16">
              <h2 className="text-brand-purple text-lg text-heading-h4 mb-4">
                Contact Us
              </h2>
              <h1 className="text-heading-h1 text-gray-900 font-bold mb-6">
                Get In Touch With Us
              </h1>
              <p className="text-body-regular text-gray-600 mx-auto">
                We&apos;re here to help and answer any questions you might have.
                We look forward to hearing from you.
              </p>
            </div>

            {/* Contact Cards */}
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
              {/* Live Support Card */}
              <div className="bg-white rounded-xl p-8 shadow-lg border border-gray-100 hover:shadow-xl transition-fast hover:scale-105">
                <div className="flex items-start">
                  <div className="w-[60px] h-full bg-brand-purple/10 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                    <Image
                      src="/social/live_message.svg"
                      alt="Live communicate"
                      width={60}
                      height={60}
                    />
                  </div>
                  <div className="flex-1">
                    <h3 className="text-caption font-semibold text-gray-900 mb-1">
                      Live Support
                    </h3>
                    <button
                      onClick={handleWhatsAppClick}
                      className="flex items-center gap-2 text-heading-h4 hover:text-brand-purple-dark transition-fast font-medium"
                    >
                      Start Chat
                      <Image
                        src="/items/arrow-left-black.svg"
                        alt="Arrow-left"
                        width={16}
                        height={16}
                        className="w-4 h-4"
                      />
                    </button>
                  </div>
                </div>
              </div>

              {/* Email Card */}
              <div className="bg-white rounded-xl p-8 shadow-lg border border-gray-100 hover:shadow-xl transition-fast hover:scale-105">
                <div className="flex items-start">
                  <div className="w-[50px] h-[50px] bg-brand-purple/10 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                    <Image
                      src="/social/mail.svg"
                      alt="mail"
                      width={50}
                      height={50}
                    />
                  </div>
                  <div className="flex-1">
                    <h3 className="text-caption font-semibold text-gray-900 mb-1">
                      Email Address
                    </h3>
                    <a
                      href="mailto:support@hostingho.com"
                      className="text-heading-h4 hover:text-brand-purple-dark transition-fast"
                    >
                      support@hostingho.com
                    </a>
                  </div>
                </div>
              </div>

              {/* Phone Card */}
              <div className="bg-white rounded-xl p-8 shadow-lg border border-gray-100 hover:shadow-xl transition-fast hover:scale-105">
                <div className="flex items-start">
                  <div className="w-[50px] h-[50px] bg-brand-purple/10 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                    <Image
                      src="/social/phone.svg"
                      alt="phone"
                      width={50}
                      height={50}
                    />
                  </div>
                  <div className="flex-1">
                    <h3 className="text-caption font-semibold text-gray-900 mb-1">
                      Phone Number
                    </h3>
                    <a
                      href="tel:+9779865029558"
                      className="text-heading-h4 hover:text-brand-purple-dark transition-fast"
                    >
                      +977-9865029558
                    </a>
                  </div>
                </div>
              </div>
            </div>

            {/* Additional Help Text */}
            <div className="text-center">
              <p className="text-body-regular text-gray-600">
                Didn&apos;t find what you were looking for? Contact us directly
                for personalized assistance.
              </p>
            </div>
          </div>
        </section>
      </div>
      <Footer />
    </>
  );
};

export default ContactUs;
