"use client";
import { FaUserCircle } from "react-icons/fa";

import { hostingMessages } from "../@data";

const ClientVoice = () => (
  <div className="w-full h-[550px] flex flex-col items-center justify-center px-5 sm:px-8 bg-white">
    <h2 className="text-heading-h1 font-bold text-center mb-2">
      Hear from Our Clients
    </h2>

    <div className="w-full max-w-4xl bg-white rounded-xl shadow-md flex flex-col items-center py-8 px-6">
      <p className="text-body-regular text-center font-medium text-gray-800 mb-6 leading-relaxed">
        &quot;{hostingMessages.clientVoice.testimonial}&quot;
      </p>

      <div className="flex flex-col items-center">
        <div className="bg-brand-purple rounded-full w-14 h-14 md:w-16 md:h-16 flex items-center justify-center mb-4">
          <FaUserCircle className="text-white" size={36} />
        </div>

        {/* Client details */}
        <div className="text-center">
          <div className="font-bold text-heading-h4 text-gray-900">
            {hostingMessages.clientVoice.author}
          </div>
          <div className="text-gray-600 text-body-regular">
            {hostingMessages.clientVoice.role}
          </div>
        </div>
      </div>
    </div>
  </div>
);

export default ClientVoice;
