"use client";
import DiscoverCard from "./DiscoverCard";
import Button from "../../../shared/components/Button";
import { useState } from "react";

const Discover = () => {
  const [activeTab, setActiveTab] = useState("Web Hosting");
  const tabs = ["Web Hosting", "Domain Registration", "Email Workspace"];

  const pricingPlans = {
    "Web Hosting": [
      {
        title: "Basic",
        price: "1400",
        period: "/year",
        features: ["1 Website", "10 GB Storage", "Free SSL", "24/7 Support"],
      },
      {
        title: "Premium",
        price: "2800",
        period: "/year",
        isPopular: true,
        features: [
          "Everything from Basic",
          "5 Websites",
          "50 GB Storage",
          "Free SSL",
          "24/7 Support",
          "Daily Backups",
        ],
      },
      {
        title: "Business",
        price: "5600",
        period: "/year",
        features: [
          "Everything from Premium",
          "Unlimited Websites",
          "Unlimited Storage",
          "Free SSL",
          "24/7 Support",
          "Daily Backups",
          "Priority Support",
        ],
      },
    ],
    "Domain Registration": [
      {
        title: "Basic",
        price: "899",
        period: "/year",
        features: [
          "1 Domain Name",
          "Free DNS Management",
          "Domain Forwarding",
          "Basic Support",
        ],
      },
      {
        title: "Premium",
        price: "1599",
        period: "/year",
        isPopular: true,
        features: [
          "Everything from Basic",
          "5 Domain Names",
          "Privacy Protection",
          "Advanced DNS",
          "Priority Support",
        ],
      },
      {
        title: "Business",
        price: "2999",
        period: "/year",
        features: [
          "Everything from Premium",
          "Unlimited Domains",
          "Brand Protection",
          "Premium DNS",
          "Dedicated Support",
        ],
      },
    ],
    "Email Workspace": [
      {
        title: "Basic",
        price: "199",
        period: "/month",
        features: [
          "5 Email Accounts",
          "10 GB Storage",
          "Web Access",
          "Basic Support",
        ],
      },
      {
        title: "Premium",
        price: "399",
        period: "/month",
        isPopular: true,
        features: [
          "Everything from Basic",
          "25 Email Accounts",
          "50 GB Storage",
          "Mobile Apps",
          "Calendar & Contacts",
          "Priority Support",
        ],
      },
      {
        title: "Business",
        price: "799",
        period: "/month",
        features: [
          "Everything from Premium",
          "Unlimited Accounts",
          "Unlimited Storage",
          "Advanced Security",
          "Team Collaboration",
          "24/7 Support",
        ],
      },
    ],
  };

  return (
    <div className="discover-component min-h-screen bg-background pt-8 md:pt-16 pb-24 relative">
      <div className="mx-auto px-[20px] md:px-[120px] max-w-[1800px] min-h-[900px]">
        <div className="text-center mb-8 md:mb-16">
          <h1 className="text-heading-h1 font-bold text-foreground mb-4">
            Discover your ideal plan
          </h1>
          <p className="text-heading-h3 !font-normal text-muted-foreground max-w-4xl mx-auto leading-relaxed">
            Choose the perfect solution for your online needs
          </p>
        </div>

        <div className="mb-8 md:mb-16">
          <div className="w-full bg-discovery-tabs rounded-full p-1 flex gap-[10px]">
            {tabs.map((tab, idx) => {
              const isActive = activeTab === tab;
              return (
                <Button
                  key={tab}
                  onClick={() => setActiveTab(tab)}
                  variant={isActive ? "primary" : "ghost"}
                  size="lg"
                  className={`px-4 py-2 text-body-regular flex-1 min-w-0 ${
                    isActive
                      ? "rounded-l-full rounded-r-full"
                      : "hover:bg-brand-purple/20 hover:rounded-l-full hover:rounded-r-full"
                  }`}
                  style={{ marginLeft: idx === 0 ? 0 : "-1px" }}
                >
                  {tab}
                </Button>
              );
            })}
          </div>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8 lg:gap-[26px] w-full">
          {pricingPlans[activeTab as keyof typeof pricingPlans].map(
            (plan, index) => {
              const tabRoute = activeTab.toLowerCase().replace(/\s+/g, "-");
              const planRoute = plan.title.toLowerCase();
              return (
                <div key={index} className="w-full">
                  <DiscoverCard
                    title={plan.title}
                    price={plan.price}
                    period={plan.period}
                    features={plan.features}
                    isPopular={plan.isPopular}
                    className="h-full text-left"
                    href={`/${tabRoute}/${planRoute}`}
                    showInlineBadge={plan.isPopular && plan.title === "Premium"}
                  />
                </div>
              );
            },
          )}
        </div>

        <p className="text-center text-caption text-muted-foreground mt-9">
          * Prices are listed without VAT
        </p>
      </div>
    </div>
  );
};

export default Discover;
