"use client";
import { Check } from "lucide-react";
import Button from "../../../shared/components/Button";
import { useState } from "react";
import Link from "next/link";

interface PricingCardProps {
  title: string;
  price: string;
  period: string;
  features: string[];
  isPopular?: boolean;
  className?: string;
  href?: string;
  showInlineBadge?: boolean;
}

const DiscoverCard = ({
  title,
  price,
  period,
  features,
  isPopular = false,
  className = "",
  href = "#",
  showInlineBadge = false,
}: PricingCardProps) => {
  const [isActive, setIsActive] = useState(false);

  return (
    <div
      className={`
        w-full 
        border-2 border-gray-300
        shadow-sm rounded-lg p-4 md:p-8  
        transition-normal 
        flex flex-col relative
        hover-card-shadow hover:border-[#7847E3]
        ${className}
        bg-card
        ${isActive ? "border-[#7847E3]" : ""}
      `}
      onClick={() => setIsActive(true)}
      onBlur={() => setIsActive(false)}
      tabIndex={0}
    >
      {/* Floating badge only if not inline */}
      {isPopular && !showInlineBadge && (
        <div className="absolute top-0 right-0 transform translate-x-2 -translate-y-2">
          <span className="text-caption font-medium bg-brand-purple text-white px-2 py-1 rounded-full">
            Most Popular
          </span>
        </div>
      )}

      <div className="text-left mb-4 md:mb-6">
        <div className="flex items-center gap-2">
          <h3 className="text-heading-h4 font-semibold text-card-foreground flex items-center">
            {title}
            {/* Inline badge if requested */}
            {showInlineBadge && (
              <span className="ml-2 text-caption font-medium bg-brand-purple text-white px-2 py-1 rounded-full">
                Most Popular
              </span>
            )}
          </h3>
        </div>

        <div className="mb-4 md:mb-6 flex items-baseline">
          <span className="text-heading-h1 font-bold text-card-foreground">
            ₹{price}
          </span>
          <span className="text-heading-h4 text-muted-foreground ml-1">
            {period}
          </span>
        </div>

        <Link href={href} className="block">
          <Button
            size="sm"
            className={`w-full mb-4 md:mb-6 !bg-white border border-brand-purple !text-[#7847E3] hover:!bg-[#7847E3] hover:!text-white !rounded-25 md:text-base md:py-2 md:px-4`}
          >
            Get Started
          </Button>
        </Link>
      </div>

      <div className="flex-1">
        <ul className="space-y-2 md:space-y-3">
          {features.map((feature, index) => (
            <li key={index} className="flex items-start gap-2 md:gap-3">
              <Check className="h-4 w-4 md:h-5 md:w-5 text-brand-purple mt-0.5 flex-shrink-0" />
              <span className="text-body-small text-muted-foreground leading-relaxed">
                {feature}
              </span>
            </li>
          ))}
        </ul>
      </div>
    </div>
  );
};

export default DiscoverCard;
