"use client";
import Button from "../../../shared/components/Button";
import { FiExternalLink } from "react-icons/fi";
import { useRouter } from "next/navigation";
import Image from "next/image";

import { hostingMessages } from "../@data";

const GettingStarted = () => {
  const router = useRouter();

  const handleWhatsAppClick = () => {
    const phoneNumber = "+9779865029558";
    const message = "Hello! I need support with HostingHo services.";
    const whatsappUrl = `https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`;
    window.open(whatsappUrl, "_blank");
  };

  return (
    <section className="relative w-full flex flex-col items-center justify-center h-[400px] overflow-hidden">
      {/* Background image & gradient */}
      <div className="absolute inset-0 w-full h-full">
        <Image
          src="/items/getstarted.png"
          alt="Background mesh"
          width={1920}
          height={400}
          className="w-full h-full object-cover object-center opacity-100"
          aria-hidden="true"
        />
        <div
          className="absolute inset-0 w-full h-full"
          style={{
            background: "linear-gradient(180deg, #7847E3 0%, #2B1A4A 100%)",
            opacity: 0.3,
          }}
        />
      </div>

      {/* Content */}
      <div className="relative z-10 flex flex-col items-center text-center px-5 md:px-10 max-w-7xl mx-auto w-full h-full justify-center">
        <h1 className="text-heading-h1 font-bold !text-white mb-4">
          {hostingMessages.gettingStarted.title}
        </h1>
        <p className="text-body-regular text-white/90 mb-8">
          {hostingMessages.gettingStarted.description}
        </p>
        <div className="flex gap-4 flex-wrap justify-center">
          <Button
            variant="primary"
            size="md"
            className="shadow-lg bg-[#7847E3] text-white hover:bg-brand-purple border-none flex items-center gap-2"
            onClick={handleWhatsAppClick}
          >
            Contact us
            <Image
              src="/social/contactus.svg"
              width={30}
              height={5}
              className=""
              alt="Live Message"
            />
          </Button>
          <Button
            variant="outline"
            size="md"
            className="!border-white !text-white hover:bg-white/10"
            onClick={() => router.push("/contact_us")}
          >
            Support {<FiExternalLink size={22} />}
          </Button>
        </div>
      </div>
    </section>
  );
};

export default GettingStarted;
