"use client";
import { useEffect, useRef, useState } from "react";
import Button from "../../../shared/components/Button";
import Image from "next/image";

import { hostingMessages } from "../@data";

const Powering = () => {
  const sectionRef = useRef<HTMLDivElement | null>(null);
  const [fixed, setFixed] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      if (!sectionRef.current) return;
      const rect = sectionRef.current.getBoundingClientRect();

      if (rect.top < window.innerHeight - 200) {
        setFixed(true);
      } else {
        setFixed(false);
      }
    };
    window.addEventListener("scroll", handleScroll);
    handleScroll();
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  return (
    <section
      ref={sectionRef}
      className="relative flex flex-col md:flex-row items-center justify-between px-5 md:px-10 lg:px-[120px] py-10 w-full min-h-[80vh]"
    >
      {/* Left: Text */}
      <div className="flex-1 flex flex-col items-start md:items-start mb-10 md:mb-0 md:mr-12">
        <span className="text-brand-purple font-bold text-heading-h4 mb-3">
          Affordable, Yet Premium
        </span>
        <h1 className="text-heading-h1 font-bold mb-6 leading-tight">
          {hostingMessages.powering.title}
        </h1>
        <p className="text-[#121212] text-body-regular mb-10 max-w-2xl">
          {hostingMessages.powering.description}
        </p>
        <Button variant="primary" size="lg" className="mt-2">
          {hostingMessages.powering.button}{" "}
          <span className="ml-2">
            <Image
              src="/items/arrow-left.svg"
              alt="arrow-left"
              width={16}
              height={16}
            />
          </span>
        </Button>
      </div>

      {/* Right: Image */}
      <div className="flex-1 flex justify-center md:justify-end w-full">
        <Image
          src="/items/world.svg"
          alt="World Map"
          width={550}
          height={350}
          className="max-w-full h-auto md:w-[550px]"
        />
      </div>

      <div
        className={`hidden md:block z-50 transition-slow cursor-pointer ${
          fixed
            ? "fixed right-[10px] bottom-[10px] opacity-100 translate-y-0"
            : "absolute right-4 bottom-20 opacity-0 translate-y-20"
        }`}
        style={{ width: 140, height: 140 }}
      >
        <Image
          src="/items/message_powering.svg"
          alt="Message Icon"
          width={140}
          height={140}
          className="w-full h-full"
        />
      </div>
    </section>
  );
};

export default Powering;
