"use client";
import type { ReactNode } from "react";
import { cn } from "../../../shared/@libs/utils";
import Link from "next/link";

interface ServiceCardProps {
  icon: ReactNode;
  title: string;
  description: string;
  className?: string;
  href?: string;
}

const ServiceCard = ({
  icon,
  title,
  description,
  className,
  href,
}: ServiceCardProps) => {
  const cardContent = (
    <div
      className={cn(
        "w-full h-full min-h-[400px] bg-card border border-gray-300 rounded-xl p-10",
        "shadow-md hover-card-shadow transition-normal",
        "flex flex-col cursor-pointer",
        "hover:bg-service-card-hover",
        className,
      )}
    >
      <div className="text-service-icon mb-8">{icon}</div>

      <h3 className="text-heading-h2 font-semibold text-card-foreground mb-6">
        {title}
      </h3>

      <p className="text-body-regular text-muted-foreground leading-relaxed flex-1">
        {description}
      </p>
    </div>
  );

  return href ? (
    <Link href={href} className="block h-full">
      {cardContent}
    </Link>
  ) : (
    cardContent
  );
};

export default ServiceCard;
