"use client";
import { Server, Globe, Mail } from "lucide-react";
import ServiceCard from "./ServiceCard";

const Services = () => {
  const services = [
    {
      icon: <Server size={48} />,
      title: "Web Hosting",
      description:
        "Fast and secure hosting with 24/7 support. Choose from shared, VPS, or dedicated servers.",
      route: "/services/hosting",
    },
    {
      icon: <Globe size={48} />,
      title: "Domain Registration",
      description:
        "Find and register your perfect domain name. Protect your brand and secure your online identity.",
      route: "/services/domains",
    },
    {
      icon: <Mail size={48} />,
      title: "Email Workspace",
      description:
        "Build trust with custom domain emails and empower your team with seamless collaboration.",
      route: "/services/email",
    },
  ];

  return (
    <div className="bg-background py-24">
      <div className="mx-auto px-[20px] md:px-[120px] max-w-[1800px]">
        <div className="text-center mb-20">
          <h1 className="text-heading-h1 font-bold text-foreground mb-4 leading-tight">
            Explore Our Core Services
          </h1>
          <p className="text-heading-h3 !font-normal text-muted-foreground max-w-4xl mx-auto leading-relaxed">
            Unlock services designed to take your online success to the next
            level.
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8 justify-items-center pb-12">
          {services.map((service, index) => (
            <ServiceCard
              key={index}
              icon={service.icon}
              title={service.title}
              description={service.description}
              href={service.route}
              className="h-full"
            />
          ))}
        </div>
      </div>
    </div>
  );
};

export default Services;
