import { motion } from "framer-motion";

type FloatingProps = {
  children: React.ReactNode;
  intensity?: number;
  duration?: number;
  rotate?: boolean;
  scale?: boolean;
  className?: string;
};

export const Floating = ({
  children,
  intensity = 15,
  duration = 3,
  rotate = false,
  scale = false,
  className = "",
}: FloatingProps) => {
  return (
    <motion.div
      className={className}
      animate={{
        y: [0, -intensity, 0],
        ...(rotate && { rotate: [0, 5, -5, 0] }),
        ...(scale && { scale: [1, 1.05, 1] }),
      }}
      transition={{
        duration,
        repeat: Infinity,
        ease: "easeInOut",
      }}
    >
      {children}
    </motion.div>
  );
};
