"use client";
import Link from "next/link";
import Image from "next/image";

const Footer = () => (
  <footer className="bg-[#151e27] text-white py-16">
    {/* Main container with consistent responsive padding */}
    <div className="w-full mx-auto px-[20px] md:px-[120px]">
      <div className="w-full flex flex-col md:flex-row md:items-start gap-y-16">
        {/* Left Block - company info */}
        <div className="flex-1 min-w-[200px] mb-8 md:mb-0">
          <div className="flex items-center gap-3 mb-6">
            <Image
              src="/items/Footerimage.svg"
              alt="HostingHo Logo"
              width={150}
              height={45}
              className="h-9"
            />
          </div>
          <p className="text-white text-caption leading-relaxed">
            Our aim is to focus on what makes hosting great: <br />
            reliable servers, easy to use systems and fantastic <br />
            customer support.
          </p>
          <div className="flex gap-[12px] mt-4">
            <a
              href="https://www.facebook.com/profile.php?id=61566490768899"
              target="_blank"
              rel="noopener noreferrer"
              className="hover:opacity-80 transition-opacity"
            >
              <Image
                src="/social/Facebook.svg"
                alt="Facebook"
                width={24}
                height={24}
                className="w-6 h-6"
              />
            </a>

            <a
              href="https://www.instagram.com/avenirtechpvtltd?igsh=eTBicHBpN25sZmdx"
              target="_blank"
              rel="noopener noreferrer"
              className="hover:opacity-80 transition-opacity"
            >
              <Image
                src="/social/Instagram.svg"
                alt="Instagram"
                width={24}
                height={24}
                className="w-6 h-6"
              />
            </a>

            <a
              href="https://www.linkedin.com/company/avenirtechpvtltd/"
              target="_blank"
              rel="noopener noreferrer"
              className="hover:opacity-80 transition-opacity"
            >
              <Image
                src="/social/LinkedIn.svg"
                alt="LinkedIn"
                width={24}
                height={24}
                className="w-6 h-6"
              />
            </a>
          </div>
        </div>

        {/* Right blocks with vertical columns */}
        <div className="flex flex-wrap gap-x-6 md:gap-x-16 gap-y-8 w-full md:w-auto">
          {/* Services */}
          <div className="flex-1 min-w-[160px]">
            <h3 className="font-semibold text-heading-h5 mb-4">Services</h3>
            <ul className="footer-list">
              <li className="footer-list-item">
                <Link
                  href="/web-hosting"
                  className="hover:text-violet-400 transition-colors"
                >
                  Web Hosting
                </Link>
              </li>
              <li className="footer-list-item ">
                <Link
                  href="/domain-registration"
                  className="hover:text-violet-400 transition-colors"
                >
                  Domain Registration
                </Link>
              </li>
              <li className="footer-list-item ">
                <Link
                  href="/email-workspace"
                  className="hover:text-violet-400 transition-colors"
                >
                  Email Workspace
                </Link>
              </li>
            </ul>
          </div>

          {/* Support */}
          <div className="flex-1 min-w-[160px]">
            <h3 className="font-semibold text-heading-h5 mb-4">Support</h3>
            <ul className="footer-list">
              <li className="footer-list-item ">
                <Link
                  href="/tutorials"
                  className="hover:text-violet-400 transition-colors"
                >
                  Tutorials
                </Link>
              </li>
              <li className="footer-list-item ">
                <Link
                  href="/contact_us"
                  className="hover:text-violet-400 transition-colors"
                >
                  Contact Us
                </Link>
              </li>
              <li className="footer-list-item ">
                <Link
                  href="/knowledgebase"
                  className="hover:text-violet-400 transition-colors"
                >
                  Knowledgebase
                </Link>
              </li>
            </ul>
          </div>

          {/* Company */}
          <div className="flex-1 min-w-[180px]">
            <h3 className="font-semibold text-heading-h6 mb-4">Company</h3>
            <ul className="footer-list">
              <li className="footer-list-item ">
                <Link
                  href="/about"
                  className="hover:text-violet-400 transition-colors"
                >
                  About Us
                </Link>
              </li>
              <li className="footer-list-item ">
                <Link
                  href="/privacy-policy"
                  className="hover:text-violet-400 transition-colors"
                >
                  Privacy Policy
                </Link>
              </li>
              <li className="footer-list-item ">
                <Link
                  href="/terms"
                  className="hover:text-violet-400 transition-colors"
                >
                  Terms and Conditions
                </Link>
              </li>
            </ul>
          </div>
        </div>
      </div>

      <hr className="my-12 border-gray-1000" />
      <div className="text-center text-gray-400 text-caption">
        &copy; {new Date().getFullYear()} HostingHo - All rights reserved
      </div>
    </div>
  </footer>
);

export default Footer;
