"use client";
import { useState, useEffect } from "react";
import Link from "next/link";
import Button from "./Button";
import Image from "next/image";

const Navbar = () => {
  const [menuOpen, setMenuOpen] = useState(false);

  useEffect(() => {
    const handleEscape = (e: KeyboardEvent) => {
      if (e.key === "Escape") setMenuOpen(false);
    };

    document.addEventListener("keydown", handleEscape);
    return () => document.removeEventListener("keydown", handleEscape);
  }, []);

  const handleOverlayClick = () => setMenuOpen(false);
  const handleSignIn = () => console.log("Sign in clicked");

  return (
    <nav className="sticky top-0 z-50 flex items-center justify-between h-[80px] w-full px-[20px] md:px-[120px] bg-white shadow-sm border-b border-gray-100">
      {/* Logo */}
      <div className="flex items-center gap-3">
        <Link href="/">
          <Image
            src="/items/hostingho_logo.svg"
            alt="HostingHo Logo"
            width={180}
            height={60}
            className="h-[45px] object-contain"
          />
        </Link>
      </div>

      <div className={`hidden md:flex items-center gap-8 transition-fast`}>
        <Link
          href="/hosting"
          className="text-navbar font-medium text-black hover:text-violet-500"
        >
          Hosting
        </Link>
        <Link
          href="/domains"
          className="text-navbar font-medium text-black hover:text-violet-500"
        >
          Domains
        </Link>
        <Link
          href="/email"
          className="text-navbar font-medium text-black hover:text-violet-500"
        >
          Email
        </Link>
        <Link
          href="/pricing"
          className="text-navbar font-medium text-black hover:text-violet-500"
        >
          Pricing
        </Link>

        <Button variant="customPurple" size="sm" onClick={handleSignIn}>
          Sign In
        </Button>
      </div>

      <button
        className="flex md:hidden flex-col justify-center items-center h-10 w-10 focus:outline-none"
        onClick={() => setMenuOpen(true)}
        aria-label="Open navigation menu"
      >
        <span className="block w-7 h-1 bg-violet-500 rounded my-0.5 transition-all" />
        <span className="block w-7 h-1 bg-violet-500 rounded my-0.5 transition-all" />
        <span className="block w-7 h-1 bg-violet-500 rounded my-0.5 transition-all" />
      </button>

      {menuOpen && (
        <>
          <div
            className="fixed inset-0 bg-black/30 backdrop-blur-sm z-40"
            onClick={handleOverlayClick}
            aria-hidden="true"
          />

          <div className="fixed top-0 left-0 h-full w-full md:w-1/2 bg-white z-50 shadow-lg flex flex-col p-6 animate-slide-in">
            <button
              className="self-start mb-8 text-heading-h2 text-black hover:text-violet-500 focus:outline-none"
              onClick={() => setMenuOpen(false)}
              aria-label="Close navigation menu"
            >
              &#10005;
            </button>

            <div className="flex-1 flex flex-col px-[20px]">
              <Link
                href="/hosting"
                className="mb-6 text-navbar font-medium text-black hover:text-violet-500"
                onClick={() => setMenuOpen(false)}
              >
                Hosting
              </Link>
              <Link
                href="/domains"
                className="mb-6 text-navbar font-medium text-black hover:text-violet-500"
                onClick={() => setMenuOpen(false)}
              >
                Domains
              </Link>
              <Link
                href="/email"
                className="mb-6 text-navbar font-medium text-black hover:text-violet-500"
                onClick={() => setMenuOpen(false)}
              >
                Email
              </Link>
              <Link
                href="/pricing"
                className="mb-6 text-navbar font-medium text-black hover:text-violet-500"
                onClick={() => setMenuOpen(false)}
              >
                Pricing
              </Link>
            </div>

            <div className="px-[20px] mt-4">
              <Button
                variant="customPurple"
                className="w-full py-3"
                onClick={() => {
                  handleSignIn();
                  setMenuOpen(false);
                }}
              >
                Sign Up
              </Button>
            </div>
          </div>
        </>
      )}
    </nav>
  );
};

export default Navbar;
