"use client";
import { useEffect, useState } from "react";

const offers = [
  {
    id: 1,
    text: "🔥 Summer deals!!! 20% off until August 1, 2025! 🛍️",
    color: "text-white",
  },
  {
    id: 2,
    text: "🚀 Flash Sale! 30% off on hosting plans - Limited time offer! ⏳",
    color: "text-yellow-300",
  },
  {
    id: 3,
    text: "🎁 Special Bundle: Domain + Hosting for just $2.99/mo! 💰",
    color: "text-green-300",
  },
  {
    id: 4,
    text: "📧 Get free business email with any annual hosting plan! ✉️",
    color: "text-blue-300",
  },
];

const DealCarousel = () => {
  const [currentIndex, setCurrentIndex] = useState(0);
  const [isVisible, setIsVisible] = useState(true);

  useEffect(() => {
    const interval = setInterval(() => {
      setIsVisible(false);

      setTimeout(() => {
        setCurrentIndex((prevIndex) => (prevIndex + 1) % offers.length);
        setIsVisible(true);
      }, 500);
    }, 3000);

    return () => clearInterval(interval);
  }, []);

  return (
    <div className="w-full h-[25px] flex items-center justify-center overflow-hidden">
      <div className="relative w-full h-full flex items-center justify-center">
        <div
          className={`absolute inset-0 flex items-center justify-center px-4 ${
            isVisible ? "animate-slide-up-in" : "animate-slide-up-out"
          }`}
          style={{
            transform: isVisible ? "translateY(0)" : "translateY(-100%)",
            opacity: isVisible ? 1 : 0,
            transition: "all 0.5s ease",
          }}
        >
          <span
            className={`text-caption font-medium ${offers[currentIndex].color} text-center leading-none`}
          >
            {offers[currentIndex].text}
          </span>
        </div>
      </div>
    </div>
  );
};

export default DealCarousel;
